/**
 * 
 */
package com.ejie.ab18a.envioBoletin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.io.FileUtils;

import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.utilidades.Ab18aConexionOracle;
import com.ejie.ab18a.utilidades.Ab18aConstantes;
import com.ejie.ab18a.utilidades.Ab18aException;

/**
 * @author XXXX
 * 
 */
public class Ab18aCargaLOB {

	private Ab18aCargaLOB() {
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Ab18aException {
		Connection connectionOracle = null;

		String nombre_metodo = "Ab18aCargaLOB";

		try {

			if (connectionOracle == null) {
				connectionOracle = Ab18aConexionOracle.conectar(args);
			}

			String pathFile = Ab18aConstantes.PATH;
			// Obtenemos los directorios que contienen los esquemas
			List<String> directorios = obtenerDirectorios(pathFile);
			PreparedStatement pstmt = null;
			PreparedStatement pstmtDelete = null;
			StringBuffer queryDelete = new StringBuffer();
			String tabla = "AB18A04S00";

			queryDelete.append("DELETE FROM " + tabla);

			pstmtDelete = connectionOracle.prepareStatement(queryDelete.toString());
			pstmtDelete.executeUpdate();

			queryDelete = new StringBuffer();
			tabla = "AB18A05S00";
			queryDelete.append("DELETE FROM " + tabla);

			pstmtDelete = connectionOracle.prepareStatement(queryDelete.toString());
			pstmtDelete.executeUpdate();

			if (pstmtDelete != null) {
				pstmtDelete.close();
			}

			// Comprobamos que existan y no estén vacíos
			if (directorios != null && !directorios.isEmpty()) {
				String sql = "";
				for (String directorio : directorios) {
					if (directorio.equals(Ab18aConstantes.XSD)) {
						sql = "INSERT INTO AB18A04S00 (T04_ID_ESQUEMA, T04_COD_ESQUEMA, T04_VERSION_ESQUEMA,T06_ID_BOLETIN,T04_FECHA_BAJA, T04_ESQUEMA)";
						sql += "VALUES (SQAB18A04.NEXTVAL,?, ?, 1,null,?)";
						pstmt = connectionOracle.prepareStatement(sql.toString());
						recorrerDirectorios(connectionOracle, pstmt, pathFile + directorio, true);
					} else if (directorio.equals(Ab18aConstantes.XLST)) {
						sql = "INSERT INTO AB18A05S00 (T05_ID_PLANTILLA_VALID, T05_COD_PLANTILLA_VALID, T05_RUTA_PLANTILLA_VALID,T06_ID_BOLETIN,T05_FECHA_BAJA, T05_PLANTILLA_VALID)";
						sql += "VALUES (SQAB18A05.NEXTVAL,?, ?, 1,null,?)";
						pstmt = connectionOracle.prepareStatement(sql.toString());
						recorrerDirectorios(connectionOracle, pstmt, pathFile + directorio, false);
					}
				}
			} else {
				Ab18aLog.debug(Ab18aCargaLOB.class.getName(), nombre_metodo, "No existen esquemas para insertar en BBDD", 1);
			}
			if (pstmt != null) {
				pstmt.close();
			}
			Ab18aConexionOracle.commit(connectionOracle);
		} catch (Exception e) {
			Ab18aConexionOracle.rollback(connectionOracle);
			throw new Ab18aException(Ab18aEnvioBoletines.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aConexionOracle.desconectar(connectionOracle);
		}
	}

	private static void recorrerDirectorios(final Connection connectionOracle, PreparedStatement pstmt, final String ruta, boolean utf8AAnsi)
			throws Ab18aException {

		String nombre_metodo = "recorrerDirectorios(Connection,PreparedStatement,String)";

		List<String> directorios = obtenerDirectorios(ruta);

		Ab18aLog.debug(Ab18aCargaLOB.class.getName(), nombre_metodo, "Directorios obtenidos: " + directorios, 1);

		List<String> esquemas = null;

		for (String directorio : directorios) {
			esquemas = obtenerEsquemas(ruta + File.separator + directorio);

			Ab18aLog.debug(Ab18aCargaLOB.class.getName(), nombre_metodo, "Esquemas encontrados: " + esquemas, 1);

			// Comprobamos que existan
			// esquemas
			if (esquemas != null && !esquemas.isEmpty()) {
				try {
					for (String esquema : esquemas) {
						Ab18aLog.debug(Ab18aCargaLOB.class.getName(), nombre_metodo, "Inserción de esquemas: " + ruta + File.separator + directorio
								+ File.separator + esquema, 1);
						pstmt = prepararBatch(connectionOracle, ruta + File.separator + directorio + File.separator, esquema, pstmt, utf8AAnsi);
					}
					pstmt.executeBatch();
				} catch (Exception ex) {
					Ab18aLog.error(Ab18aCargaLOB.class.getName(), nombre_metodo,
							"Error al tratar el batch de reglas de validacion a insertar: " + ex, 1);
				}
			}

			recorrerDirectorios(connectionOracle, pstmt, ruta + File.separator + directorio, utf8AAnsi);
		}
	}

	public static String readFile(String fileName, Writer writerArg) throws FileNotFoundException, IOException {

		BufferedReader br = new BufferedReader(new FileReader(fileName));
		String nextLine = "";
		StringBuffer sb = new StringBuffer();
		while ((nextLine = br.readLine()) != null) {
			writerArg.write(nextLine);
			sb.append(nextLine);
		}
		// Convert the content into to a string
		String clobData = sb.toString();

		// Return the data.
		return clobData;
	}

	private static List<String> obtenerDirectorios(String pathFile) {
		File directorioPrincipal = new File(pathFile);
		String[] directorios = directorioPrincipal.list(new FilenameFilter() {
			@Override
			public boolean accept(File current, String name) {
				return new File(current, name).isDirectory();
			}
		});

		return Arrays.asList(directorios);
	}

	private static List<String> obtenerEsquemas(String directorio) {
		File rutaEsquemas = new File(directorio);
		String[] esquemas = rutaEsquemas.list(new FilenameFilter() {
			@Override
			public boolean accept(File current, String name) {
				return new File(current, name).isFile();
			}
		});

		return Arrays.asList(esquemas);
	}

	private static PreparedStatement prepararBatch(Connection connectionOracle, String pathFile, String esquema, PreparedStatement pstmt,
			boolean utf8AAnsi) throws SQLException, FileNotFoundException, IOException {

		Clob myClob = connectionOracle.createClob();
		Writer clobWriter = myClob.setCharacterStream(1);

		String str = "";

		if (utf8AAnsi) {
			str = Ab18aCargaLOB.readFile(UTF8ToAnsi(pathFile + File.separator + esquema), clobWriter);
		} else {
			str = Ab18aCargaLOB.readFile(pathFile + File.separator + esquema, clobWriter);
		}

		myClob.setString(1, str);

		pstmt.setString(1, esquema);
		pstmt.setString(2, pathFile);
		pstmt.setClob(3, myClob);
		pstmt.addBatch();

		return pstmt;
	}

	private static String UTF8ToAnsi(String ruta) {
		try {
			boolean firstLine = true;
			File fichero = new File("/datos/ab18a/temporal/prueba.xml");
			fichero.getParentFile().mkdirs();

			FileInputStream fis = new FileInputStream(ruta);
			BufferedReader r = new BufferedReader(new InputStreamReader(fis, "UTF8"));
			FileOutputStream fos = new FileOutputStream(fichero);
			Writer w = new BufferedWriter(new OutputStreamWriter(fos, "Cp1252"));
			for (String s = ""; (s = r.readLine()) != null;) {
				if (firstLine) {
					s = removeUTF8BOM(s);
					firstLine = false;
				}
				w.write(s + System.getProperty("line.separator"));
				w.flush();
			}

			w.close();
			r.close();
			FileUtils.copyFile(new File("/datos/ab18a/temporal/prueba.xml"), new File(ruta));
		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return ruta;
	}

	private static String removeUTF8BOM(String s) {
		if (s.startsWith(Ab18aConstantes.UTF8_BOM)) {
			s = s.substring(1);
		}
		return s;
	}
}
